unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, Menus;

type
  TForm1 = class(TForm)
    ColorDialog1: TColorDialog;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Shape6: TShape;
    Shape7: TShape;
    Shape8: TShape;
    Shape9: TShape;
    Shape10: TShape;
    Shape11: TShape;
    Shape12: TShape;
    Shape13: TShape;
    Image1: TImage;
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Shape2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
Image1.Canvas.MoveTo(x,y);
if not SpeedButton2.Enabled then
 begin
  Image1.Canvas.Brush.Color:=Shape1.Brush.Color;
  Image1.Canvas.FloodFill(X,Y,Image1.Canvas.Pixels[x,y],fsSurface);
 end;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if not SpeedButton1.Enabled then
  if Shift=[ssLeft] then Image1.Canvas.LineTo(x,y);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 Image1.Canvas.Moveto(0,0);
 Shape1.Brush.Color:=clBlack;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
 SpeedButton1.Enabled:=not SpeedButton1.Enabled;
 SpeedButton2.Enabled:=not SpeedButton2.Enabled;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
 if ColorDialog1.Execute then
  begin
   Image1.Canvas.Pen.Color:=ColorDialog1.Color;
   Shape1.Brush.Color:=ColorDialog1.Color;
  end;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
 If OKBottomDlg.ShowModal=mrOK then
  Image1.Canvas.Pen.Width:=StrToInt(OKBottomDlg.Combobox1.Text);
end;


procedure TForm1.Open1Click(Sender: TObject);
begin
 if OpenDialog1.Execute then
  begin
   Image1.Picture.LoadFromFile(OpenDialog1.FileName);
  end;
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
 if SaveDialog1.Execute then
  begin
   Image1.Picture.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TForm1.Shape2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 Image1.Canvas.Pen.Color:=TShape(Sender).Brush.Color;
 Shape1.Brush.Color:=TShape(Sender).Brush.Color;
end;

end.
